﻿

*****************************               Get variables from the housing section                            ************************************************.



***To estimate the vlue of the house for those without rent or those with rent but with no value or outliers .

cd 'C:\1 Suriname\Analysis'  .




***Get the value of rent paid from Module 14.b   variable code 1101

GET FILE='14bcd_NonFood.sav'
   / keep =  hhid nfcode q141_02_ q141_02 .

FILTER OFF.
USE ALL.
SELECT IF (nfcode = 1101).
EXECUTE.

***220 cases 

***only cses with positive information .

FILTER OFF.
USE ALL.
SELECT IF (q141_02_ > 0 or q141_02 > 0).
EXECUTE.

***217 cases .

COMPUTE aaa=q141_02 - q141_02_.
EXECUTE.

FREQUENCIES VARIABLES=aaa
  /ORDER=ANALYSIS.

***only 0's  This mean that for this product, the reported values are unchanged.

compute rent_paid = q141_02_   * 12 .
variable label rent_paid "Yearly rent paid for the house" .


AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=
  /rent_paid_mean=MEAN(rent_paid) 
  /rent_paid_sd=SD(rent_paid).

COMPUTE  SDM=ABS (RND (  (( rent_paid - rent_paid_mean)/rent_paid_sd)   ,0.1) ).
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

***All the values are bellow 5 standard deviation, do not change any reported value.

DELETE VARIABLES  rent_paid_mean rent_paid_sd SDM  .

format  rent_paid (comma8.0) .

SAVE OUTFILE='borrar.sav'
  /keep =  hhid  rent_paid.

*************.

GET FILE='borrar.sav'  .

***Average yearly rent paid:  SRD 9,862 (median = 7,800) .

*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.

***Get the file with the house characteristics and add the rent paid .



GET FILE='00_12a_13_16_singles_Housing.sav'.


SORT CASES BY hhid(A).

MATCH FILES /FILE=*
  /FILE='borrar.sav'
  /BY hhid.
EXECUTE.

COMPUTE ln_rent_paid=LN(rent_paid).
VARIABLE LABELS  ln_rent_paid 'Natural logarith of rent paid'.
EXECUTE.

COMPUTE q13_18_pc = q13_18 / hh_size.
COMPUTE q13_19_pc = q13_19 / hh_size.
COMPUTE q13_20_pc = q13_20 / hh_size.
COMPUTE q13_21_pc = q13_21 / hh_size.
COMPUTE q13_22_pc = q13_22 / hh_size.
EXECUTE.

***ID posible correlates to rent paid.

USE ALL.
COMPUTE filter_$=(rent_paid > 0).
FILTER BY filter_$.
EXECUTE.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_04.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_18.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_19.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_20.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_21.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_22.


RECODE q13_12a q13_12b q13_12c q13_12d q13_12e q13_12f q13_12g (SYSMIS=0).
EXECUTE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=q13_01 q13_02 q13_03 q13_05 q13_08 q13_09 q13_10 q13_11 q13_12a q13_12b 
    q13_12c q13_12d q13_12e q13_12f q13_12g q13_13 q13_14 q13_15 q13_16 q13_17 q13_23a q13_23b q13_23c 
    q13_23d q13_23e q13_23f q13_23g q13_23h q13_23i q13_24 rent_paid 
    DISPLAY=DEFAULT
  /TABLE q13_01 [C] + q13_02 [C] + q13_03 [C] + q13_05 [C] + q13_08 [C] + q13_09 [C] + q13_10 [C] + 
    q13_11 [C] + q13_12a [C] + q13_12b [C] + q13_12c [C] + q13_12d [C] + q13_12e [C] + q13_12f [C] + 
    q13_12g [C] + q13_13 [C] + q13_14 [C] + q13_15 [C] + q13_16 [C] + q13_17 [C] + q13_23a [C] + 
    q13_23b [C] + q13_23c [C] + q13_23d [C] + q13_23e [C] + q13_23f [C] + q13_23g [C] + q13_23h [C] + 
    q13_23i [C] + q13_24 [C] BY rent_paid [S][MEAN, COUNT F40.0]
  /CATEGORIES VARIABLES=q13_01 [1, 2, 3, 4, 5] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=q13_02 q13_03 q13_05 q13_08 q13_09 q13_10 q13_11 q13_13 q13_14 q13_15 
    q13_16 q13_17 q13_24 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=q13_12a q13_12b q13_12c q13_12d q13_12e q13_12f q13_12g q13_23a q13_23b 
    q13_23c q13_23d q13_23e q13_23f q13_23g q13_23h q13_23i ORDER=A KEY=VALUE EMPTY=EXCLUDE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=domain domain2 rent_paid DISPLAY=DEFAULT
  /TABLE domain [C] + domain2 [C] BY rent_paid [S][MEAN, COUNT F40.0]
  /CATEGORIES VARIABLES=domain domain2 ORDER=A KEY=VALUE EMPTY=INCLUDE.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_18_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_19_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_20_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_21_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_22_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER HH_SIZE.

FILTER OFF.
USE ALL.
EXECUTE.

COMPUTE paramaribo = (DOMAIN = 1) .
COMPUTE rest_costal= (DOMAIN = 2).
execute .

COMPUTE q13_08_1_2 = (q13_08 > 2) .
COMPUTE q13_09_1 = (q13_09 = 1) .
COMPUTE q13_10_1_3_5 = (q13_10 = 1 or q13_10 = 3 or q13_10 = 5) .
COMPUTE q13_12a_1 = (q13_12a = 1) .
COMPUTE q13_12c_1 = (q13_12c = 1) .
COMPUTE q13_12d_1 = (q13_12d = 1) .
COMPUTE q13_12e_1 = (q13_12e = 1) .
COMPUTE q13_12f_1 = (q13_12f = 1) .
COMPUTE q13_12g_1 = (q13_12g = 1) .
COMPUTE q13_14_1 = (q13_14 = 1) .
COMPUTE q13_12c_1 = (q13_15 = 1) .
COMPUTE q13_23a_1 = (q13_23a > 0) .
COMPUTE q13_23c_1 = (q13_23c > 0) .
COMPUTE q13_23d_1 = (q13_23d > 0) .
COMPUTE q13_23e_1 = (q13_23e > 0) .
COMPUTE q13_23i_1 = (q13_23i > 0) .
COMPUTE  q13_18_number = q13_18.
COMPUTE  q13_19_number = q13_19.
EXECUTE .

DELETE VARIABLES Q13_18_PC  Q13_20_PC Q13_21_PC Q13_22_PC  filter_$.



SAVE OUTFILE='f House1.sav'  .

*************.

GET FILE='f House1.sav'  .

*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.




*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.
*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.
*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.

GET FILE='f House1.sav'  
  /keep = hhid domain gp_subdom domain2  stratum psu psus_N density  urban_66_0 weight  hh_size rent_paid 
    ln_rent_paid  q13_19_pc paramaribo rest_costal q13_08_1_2 q13_09_1 q13_10_1_3_5 q13_12a_1 
    q13_12c_1 q13_12d_1 q13_12e_1 q13_12f_1 q13_12g_1 q13_14_1 q13_23a_1 q13_23c_1 q13_23d_1 q13_23e_1 
    q13_23i_1  q13_18_number q13_19_number.

FREQUENCIES VARIABLES=hhid ln_rent_paid  q13_19_pc paramaribo rest_costal q13_08_1_2 q13_09_1 
    q13_10_1_3_5 q13_12a_1 q13_12c_1 q13_12d_1 q13_12e_1 q13_12f_1 q13_12g_1 q13_14_1 q13_23a_1 
    q13_23c_1 q13_23d_1 q13_23e_1 q13_23i_1 q13_18_number q13_19_number
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.

***Variables have 0, 1, 3 o 4 mising values. 

***in all cases use the median.

SORT CASES domain2 (a) .
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=domain2
  /q13_19_pc_median=MEDIAN(q13_19_pc) 
  /q13_08_1_2_median=MEDIAN(q13_08_1_2) 
  /q13_09_1_median=MEDIAN(q13_09_1) 
  /q13_10_1_3_5_median=MEDIAN(q13_10_1_3_5) 
  /q13_12c_1_median=MEDIAN(q13_12c_1) 
  /q13_23a_1_median=MEDIAN(q13_23a_1) 
  /q13_23c_1_median=MEDIAN(q13_23c_1) 
  /q13_23d_1_median=MEDIAN(q13_23d_1) 
  /q13_23e_1_median=MEDIAN(q13_23e_1) 
  /q13_23i_1_median=MEDIAN(q13_23i_1) 
  /q13_18_number_median=MEDIAN(q13_18_number) 
  /q13_19_number_median=MEDIAN(q13_19_number).

IF  (MISSING(q13_19_pc)) q13_19_pc=q13_19_pc_median.
IF  (MISSING( q13_08_1_2 )) q13_08_1_2 =  q13_08_1_2_median.
IF  (MISSING( q13_09_1 )) q13_09_1 =  q13_09_1_median.
IF  (MISSING( q13_10_1_3_5 )) q13_10_1_3_5 =  q13_10_1_3_5_median.
IF  (MISSING( q13_12c_1 )) q13_12c_1 =  q13_12c_1_median.
IF  (MISSING(  q13_23a_1))  q13_23a_1=  q13_23a_1_median.
IF  (MISSING( q13_23c_1 ))  q13_23c_1   =  q13_23c_1_median.
IF  (MISSING(  q13_23d_1))  q13_23d_1=  q13_23d_1_median.
IF  (MISSING(q13_23e_1  ))  q13_23e_1=  q13_23e_1_median.
IF  (MISSING( q13_23i_1 ))  q13_23i_1=  q13_23i_1_median.
IF  (MISSING(q13_18_number  ))  q13_18_number=  q13_18_number_median.
IF  (MISSING(q13_19_number  ))  q13_19_number=  q13_19_number_median.
EXECUTE.

FREQUENCIES VARIABLES=hhid ln_rent_paid  q13_19_pc paramaribo rest_costal q13_08_1_2 q13_09_1 
    q13_10_1_3_5 q13_12a_1 q13_12c_1 q13_12d_1 q13_12e_1 q13_12f_1 q13_12g_1 q13_14_1 q13_23a_1 
    q13_23c_1 q13_23d_1 q13_23e_1 q13_23i_1 q13_18_number q13_19_number
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.

***All the independent (X's) variables have values.

DELETE VARIABLES   q13_19_pc_median q13_08_1_2_median q13_09_1_median q13_10_1_3_5_median 
    q13_12c_1_median q13_23a_1_median q13_23c_1_median q13_23d_1_median q13_23e_1_median 
    q13_23i_1_median q13_18_number_median q13_19_number_median  .

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER  paramaribo rest_costal q13_18_number q13_19_number q13_19_pc q13_08_1_2 
    q13_09_1 q13_10_1_3_5 q13_12a_1 q13_12c_1 q13_12d_1 q13_12e_1 q13_12f_1 q13_12g_1 q13_14_1 
    q13_23a_1 q13_23c_1 q13_23d_1 q13_23e_1 q13_23i_1.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER  paramaribo    q13_19_number   q13_08_1_2 
      q13_12d_1 q13_12e_1   q13_12g_1  
     q13_23e_1  
  /SAVE PRED.

IF  (MISSING(q13_19_pc)) est_rent=EXP(PRE_1).
VARIABLE LABELS  est_rent 'Rent estimated with regression /year/HH'.
EXECUTE.

COMPUTE est_rent=EXP(PRE_1).
VARIABLE LABELS  est_rent 'Rent estimated with regression /year/HH'.
EXECUTE.

DESCRIPTIVES VARIABLES=est_rent rent_paid
  /STATISTICS=MEAN STDDEV MIN MAX.

***The estimated rent average value is lower and the range is smaller than actual rent paid.

COMPUTE rent=rent_paid.
VARIABLE LABELS  rent 'Rent paid (M14.B.1101) / HH /year'.
EXECUTE.

IF  (MISSING(rent)) house=est_rent.
VARIABLE LABELS  house 'Use value of house estimated with regresion / HH /year'.
EXECUTE.

RECODE rent house (SYSMIS=0).
EXECUTE.

IF  ((rent = 0 and house > 0) or (house = 0 and rent > 0)) OK=1.
VARIABLE LABELS  OK 'Use value of house estimated with regresion Year/HH'.
EXECUTE.

FREQUENCIES VARIABLES=OK
  /ORDER=ANALYSIS.

SORT CASES BY hhid(A) .

compute rent_ex = 0 .
compute house_ex = 0 .
execute .

VARIABLE LEVEL  rent   rent_ex   house   house_ex (scale) .
FORMATS  rent rent_ex house house_ex (Comma8.2) .

VARIABLE LABELS  house_ex 'Estimated Use value of house estimated with regresion / HH /year'.
VARIABLE LABELS  rent_ex 'Estimated Rent paid (M14.B.1101) / HH /year'.

SAVE OUTFILE='f House2.sav' 
   /keep  =  hhid rent rent_ex house house_ex  .

*************.

GET FILE='f House2.sav'  .

ERASE file ='borrar.sav' . 



****** edu1   food1   heal1   food2 toba   tran1   tran2   fun1   comm1    food3  rent    house     .



